/*
 * Decompiled with CFR 0.152.
 */
package izone.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JOptionPane;

public class DataConnection {
    private String url = "";
    private String DRIVER = "";
    private Connection conn = null;
    private Statement stmt = null;
    private ResultSet rset = null;

    public DataConnection() {
        String separator = System.getProperty("file.separator");
        String rootPath = System.getProperty("user.dir");
        String imgPath = rootPath + separator + "db" + separator;
        this.url = "jdbc:sqlite:" + imgPath + "izonedb.db";
        this.DRIVER = "org.sqlite.JDBC";
    }

    public Connection connect() {
        try {
            Class.forName(this.DRIVER);
            this.conn = DriverManager.getConnection(this.url);
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(null, "1" + sqle.getMessage());
            System.exit(0);
        }
        catch (ClassNotFoundException cnfe) {
            JOptionPane.showMessageDialog(null, "2" + cnfe.getMessage());
            System.exit(0);
        }
        return this.conn;
    }

    public void disconnect() {
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
            if (this.rset != null) {
                this.rset.close();
                this.conn = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(null, sqle.getMessage());
            System.exit(1);
        }
    }

    public PreparedStatement preparedStatement(String query) {
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepareStatement(query);
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(null, sqle.getMessage());
        }
        return stmt;
    }

    public Statement statement(String query) {
        Statement stat = null;
        try {
            stat = this.conn.createStatement();
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(null, sqle.getMessage());
        }
        return stat;
    }

    public ResultSet getResultSet(String query) {
        ResultSet rstat = null;
        Statement stat = null;
        try {
            stat = this.conn.createStatement();
            this.conn.setAutoCommit(false);
            rstat = stat.executeQuery(query);
        }
        catch (SQLException sqle) {
            JOptionPane.showMessageDialog(null, sqle.getMessage());
        }
        return rstat;
    }

    public static void main(String[] args) {
        String userHome = System.getProperty("user.home");
        String separator = System.getProperty("file.separator");
        String rootPath = System.getProperty("user.dir");
        String imgPath = rootPath + separator + "db" + separator;
        System.out.println(userHome);
        System.out.println(imgPath);
    }
}

