/*
 * Decompiled with CFR 0.152.
 */
package izone.client.util;

import izone.client.util.Hex;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class getMAC {
    public static String getMac() throws IOException {
        String result = "";
        InetAddress addr = InetAddress.getLocalHost();
        NetworkInterface ni = NetworkInterface.getByInetAddress(addr);
        byte[] data = ni.getHardwareAddress();
        if (data == null) {
            result = "00-00-00-00-00-00";
            return "00-00-00-00-00-00";
        }
        result = new String(Hex.encode(data)).toUpperCase();
        String mac = result.substring(0, 2) + "-" + result.substring(2, 4) + "-" + result.substring(4, 6) + "-" + result.substring(6, 8) + "-" + result.substring(8, 10) + "-" + result.substring(10, 12);
        return mac;
    }

    public static String getMacAddr() throws IOException {
        String mac = "";
        String result = "";
        ArrayList<InetAddress> addrList = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface ifc = interfaces.nextElement();
            Enumeration<InetAddress> addressesOfAnInterface = ifc.getInetAddresses();
            byte[] addr = ifc.getHardwareAddress();
            while (addressesOfAnInterface.hasMoreElements()) {
                InetAddress address = addressesOfAnInterface.nextElement();
                if (address.equals(localhost) || address.toString().contains(":") || mac != null && mac != "") continue;
                addrList.add(address);
                result = addr == null ? "00-00-00-00-00-00" : new String(Hex.encode(addr)).toUpperCase().trim();
                mac = result.substring(0, 2) + "-" + result.substring(2, 4) + "-" + result.substring(4, 6) + "-" + result.substring(6, 8) + "-" + result.substring(8, 10) + "-" + result.substring(10, 12);
            }
        }
        return mac;
    }

    public static void main(String[] args) {
        try {
            getMAC.getMacAddr();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

