/*
 * Decompiled with CFR 0.152.
 */
package izone.client.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;

public class DrawingPanel
extends JPanel {
    private int fontSize = 90;
    private String message = "Java 2D";
    private int messageWidth;

    public DrawingPanel() {
        this.setBackground(Color.white);
        Font font = new Font("Serif", 0, this.fontSize);
        this.setFont(font);
        FontMetrics metrics = this.getFontMetrics(font);
        this.messageWidth = metrics.stringWidth(this.message);
        int width = this.messageWidth * 5 / 3;
        int height = this.fontSize * 3;
        this.setPreferredSize(new Dimension(width, height));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        int x = this.messageWidth / 10;
        int y = this.fontSize * 5 / 2;
        g2d.translate(x, y);
        g2d.setPaint(Color.lightGray);
        AffineTransform origTransform = g2d.getTransform();
        g2d.shear(-0.95, 0.0);
        g2d.scale(1.0, 3.0);
        g2d.drawString(this.message, 0, 0);
        g2d.setTransform(origTransform);
        g2d.setPaint(Color.black);
        g2d.drawString(this.message, 0, 0);
    }
}

