package izone.client.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ListNets 
{
    public static void main(String args[]) throws SocketException {
        List<InetAddress> addrList = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        } catch (SocketException e) {
            e.printStackTrace();
        }

        InetAddress localhost = null;

        try {
            localhost = InetAddress.getByName("127.0.0.1");
        } catch (UnknownHostException e) {
            e.printStackTrace();
        }

        while (interfaces.hasMoreElements()) {
            NetworkInterface ifc = interfaces.nextElement();
            Enumeration<InetAddress> addressesOfAnInterface = ifc.getInetAddresses();
            byte[] addr = ifc.getHardwareAddress();
            

            
            while (addressesOfAnInterface.hasMoreElements()) {
                InetAddress address = addressesOfAnInterface.nextElement();

                if (!address.equals(localhost) && !address.toString().contains(":")) {
                    addrList.add(address);
                    System.out.println("FOUND ADDRESS ON NIC: " + address.getHostAddress());
                    String result="";
                    
            		if(addr==null)
            			result="00-00-00-00-00-00";
            		
            		result = new String(Hex.encode(addr)).toUpperCase();
            		String mac= result.substring(0, 2)+"-"+result.substring(2, 4)+
					"-"+result.substring(4, 6)+"-"+	result.substring(6,8)+
					"-"+result.substring(8, 10)+"-"+result.substring(10, 12);
		            		
            		 System.out.println("FOUND MAC     ON NIC: " + mac);                    
                   
                }
            }
        }



    }

}  