package izone.client;

import javax.imageio.ImageIO;
import javax.swing.*;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;


import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;

import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.Date;

import izone.client.util.ExitListener;
import izone.client.util.getMAC;
import izone.client.util.Encryption;
import izone.client.util.Utils;
import izone.dao.ClientCollection;
import izone.dao.parameter;
import izone.dao.parameterDAO;
import izone.dao.transaction;
import izone.dao.transactionDAO;


/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class mainClient extends javax.swing.JFrame {
	private JTextArea jTextArea1;

	private JInternalFrame jInternalFrame1;
	private JTextField jTextField1;
	private JLabel jLabel2;
	private JLabel jLabel3;
	private JLabel jLabel4;
	private JLabel jLabel5;
	private JScrollPane jScrollPane1;
	private JTextField txtPIN;
	private JTextField txtNoTujuan;
	private JButton btnOK;
	private JComboBox cboNominal;
	private JComboBox cboVoucherType;
	private JToggleButton jToggleButton3;
	private JToggleButton jToggleButton2;
	private JComboBox cboType;
	private JComboBox cboProduk;
	private JLabel jLabel8;
	private JLabel jLabel7;
	private JLabel jLabel6;
	private JLabel jLabel1;
	private JToggleButton jToggleButton1;
	private JToolBar jToolBar1;
	private JTable jTable1;
	private static DefaultTableModel tabMode;
	
	private static SimpleDateFormat sdf;



	public static void main(String[] args){
		//Set Look & Feel
		try {
			javax.swing.UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
//			javax.swing.UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
//			javax.swing.UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
//			javax.swing.UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
			
		}	
	    catch (UnsupportedLookAndFeelException e) {
	        e.printStackTrace();
	     }
	     catch (ClassNotFoundException e) {
	        e.printStackTrace();
	     }
	     catch (InstantiationException e) {
	        e.printStackTrace();
	     }
	     catch (IllegalAccessException e) {
	        e.printStackTrace();
	     }		
		mainClient mClient = new mainClient();
	}
	
	public mainClient()
	{
		super();
		sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		initGUI(1);
	}
	
	private int initGUI(int status){
		try{	
			addWindowListener(new ExitListener());
			Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
			
			setTitle("iZone Client");
			getContentPane().setLayout(null);
			setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		
			BufferedImage image=ImageIO.read(new File("src/izone/pic/CircleLogo.jpg"));
				
			setIconImage(image);

			int lebar =(screen.width - getWidth())/3;
			int tinggi = (screen.height - getHeight())/3;		

			this.setLocation(new java.awt.Point(lebar, tinggi));
			this.pack();
			this.setSize(1214, 493);
			this.setVisible(true);
			this.setPreferredSize(new java.awt.Dimension(1214, 493));
			this.setResizable(false);
			setExtendedState(getExtendedState()|JFrame.MAXIMIZED_BOTH);
			{
				jInternalFrame1 = new JInternalFrame();
				getContentPane().add(jInternalFrame1);
				jInternalFrame1.setBounds(19, 280, 538, 176);
				jInternalFrame1.setVisible(false);
				jInternalFrame1.setLayout(null);
				{
					jLabel2 = new JLabel();
					jInternalFrame1.getContentPane().add(jLabel2);
					jLabel2.setText("Pilih Type Voucher untuk melakukan Isi Ulang Pulsa");
					jLabel2.setBounds(26, 18, 374, 15);
				}
				{
					jLabel1 = new JLabel();
					jInternalFrame1.getContentPane().add(jLabel1);
					jLabel1.setText("Voucher Type");
					jLabel1.setBounds(26, 108, 84, 22);
				}
				{
					jLabel3 = new JLabel();
					jInternalFrame1.getContentPane().add(jLabel3);
					jLabel3.setText("Produk");
					jLabel3.setBounds(26, 51, 43, 15);
				}
				{
					jLabel4 = new JLabel();
					jInternalFrame1.getContentPane().add(jLabel4);
					jLabel4.setText("Type");
					jLabel4.setBounds(26, 81, 43, 15);
				}
				{
					jLabel5 = new JLabel();
					jInternalFrame1.getContentPane().add(jLabel5);
					jLabel5.setText("jLabel1");
					jLabel5.setBounds(133, 158, 43, 15);
				}
				{
					jLabel6 = new JLabel();
					jInternalFrame1.getContentPane().add(jLabel6);
					jLabel6.setText("No. Tujuan");
					jLabel6.setBounds(231, 49, 73, 21);
				}
				{
					jLabel7 = new JLabel();
					jInternalFrame1.getContentPane().add(jLabel7);
					jLabel7.setText("Nominal");
					jLabel7.setBounds(231, 76, 73, 21);
				}
				{
					jLabel8 = new JLabel();
					jInternalFrame1.getContentPane().add(jLabel8);
					jLabel8.setText("PIN");
					jLabel8.setBounds(231, 107, 73, 21);
				}
				{
					ComboBoxModel cboProdukModel = 
						new DefaultComboBoxModel(
								new String[] { "Seluler"});
					cboProduk = new JComboBox();
					jInternalFrame1.getContentPane().add(cboProduk);
					cboProduk.setModel(cboProdukModel);
					cboProduk.setBounds(118, 48, 81, 22);
					cboProduk.setEditable(false);
					cboProduk.requestFocusInWindow();
					
				}
				{
					ComboBoxModel jComboBox1Model = 
						new DefaultComboBoxModel(
								new String[] { "Indosat", "Telkomsel","XL",
										"Fren","Smart","Three","Axis","Flexi","Esia"});
					cboType = new JComboBox();
					jInternalFrame1.getContentPane().add(cboType);
					cboType.setModel(jComboBox1Model);
					cboType.setBounds(118, 77, 81, 22);
					cboType.setEditable(false);
				}
				{
					ComboBoxModel jComboBox2Model = 
						new DefaultComboBoxModel(
								new String[] { "Reguler", "SMS","Extra" });
					cboVoucherType = new JComboBox();
					jInternalFrame1.getContentPane().add(cboVoucherType);
					cboVoucherType.setModel(jComboBox2Model);
					cboVoucherType.setBounds(118, 108, 81, 22);
					cboVoucherType.setEditable(false);
				}
				{
					ComboBoxModel jComboBox4Model = 
						new DefaultComboBoxModel(
								new String[] { "5000", "10000","15000",
										"20000","25000","50000","100000",
										"200000"});
					cboNominal = new JComboBox();
					jInternalFrame1.getContentPane().add(cboNominal);
					cboNominal.setModel(jComboBox4Model);
					cboNominal.setBounds(316, 77, 81, 22);
					cboNominal.setEditable(true);
				}
				{
					btnOK = new JButton();
					jInternalFrame1.getContentPane().add(btnOK);
					btnOK.setText("Isi Ulang");
					btnOK.setBounds(422, 47, 83, 50);
					btnOK.addActionListener(new ActionListener(){
						public void actionPerformed(ActionEvent ev){
 
							String url = "";
							String terminalID ="";
							String version = "";
							String key = "";
							String mac= "";
							String voucherType="";
							String responseCode="99";
							
							try{
								
								parameter data = new parameter();
								parameterDAO dao = new parameterDAO();
								
								transaction trx = new transaction();
								transactionDAO trxDao = new transactionDAO();				
								
								if (data==null){										
									System.out.println("Gagal");
									JOptionPane.showMessageDialog(null,
											"Login Gagal\n Coba Lagi\nPesan Error :\n" + "<html><font color=#0000FF>" +
											"Gagal" + "</font></html>");
									System.exit(1);
								}
								
								url="http://202.169.46.85:7002/connector/iposgateway";
								
								data = dao.selectByparameterID("1");
								
								terminalID = data.getTerminalID();
								version = data.getVersion();
								key = data.getCipherKey();
								mac= getMAC.getMacAddr();
								voucherType=cboVoucherType.getSelectedItem().toString();
								
								if(mac==null)
									mac="00-00-00-00-00-00";
								
								String logID=null;
								Date date=new Date();
								String trxType=cboType.getSelectedItem().toString();
								String productID="Topup";
								String amount=cboNominal.getSelectedItem().toString();
								String payee=txtNoTujuan.getText().trim();
								String serialNo="";
								String refNo="";
								String trxStatus="none";
								String previousBalance="0";
								String currentBalance="0";
								
								
								trx.setLogID(logID);
								trx.setTrxDate(date);
								trx.setTrxType(trxType);
								trx.setProductID(productID);
								trx.setAmount(amount);
								trx.setPayee(payee);
								trx.setSerialNo(serialNo);
								trx.setReferenceNo(refNo);
								trx.setTrxStatus(trxStatus);								
								trx.setPreviousBalance(previousBalance);
								trx.setCurrentBalance(currentBalance);
								
								XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
								config.setServerURL(new URL(url));
								XmlRpcClient client = new XmlRpcClient();
								client.setConfig(config);		
								
								Encryption enc = new Encryption();
								
								Hashtable struct = new Hashtable();
								struct.put("TransactionDateTime",date);
								struct.put("ProcessingCode","700000");
								struct.put("TransactionID","1");
								struct.put("Destination",enc.performEncrypt(payee,key));
								struct.put("Amount",enc.performEncrypt(amount,key));
								struct.put("Version",version);
								struct.put("VoucherType",voucherType.substring(0, 1));
								struct.put("PIN",enc.performEncrypt(txtPIN.getText().trim(),key)); //enc
								struct.put("FirstName",enc.performEncrypt("user",key)); //enc
								struct.put("MerchantType","6012");						
								struct.put("TerminalID", terminalID);
								struct.put("MerchantID","6012");
								struct.put("CardName",trxType);
								struct.put("CardNumber",Utils.getCardNumber(cboType.getSelectedItem().toString()));
								
								struct.put("MACAddress",mac);
								
								Vector params = new Vector();
								params.add(struct);
								//	params.add(new Integer(1));
								//	params.add(new Integer(1861));
								

								System.out.println(struct.toString());
								
								
								
								HashMap result = (HashMap) client.execute("iZoneGateway.topupRequest", params);
								
								System.out.println("response" +result.toString());
								
								responseCode = result.get("ResponseCode").toString();
								
								
								if(responseCode.equals("00")||responseCode.equals("00")){
									
									System.out.println("Sukses");
									JOptionPane.showMessageDialog(null,
											"<html><font color=#0000FF>Login Berhasil </font></html>");
																
								}
								
							}catch(Exception e){
								e.printStackTrace();
							}
							
							
						}
					});
				}
				{
					txtNoTujuan = new JTextField();
					jInternalFrame1.getContentPane().add(txtNoTujuan);
					txtNoTujuan.setBounds(316, 49, 89, 22);
				}
				{
					txtPIN = new JTextField();
					jInternalFrame1.getContentPane().add(txtPIN);
					txtPIN.setBounds(316, 108, 89, 20);
				}
			}
			
			
			{
				jToolBar1 = new JToolBar();
				getContentPane().add(jToolBar1);
				jToolBar1.setBounds(0, 0, 1716, 67);
				jToolBar1.setFloatable(false);
				{
					BufferedImage imgVoucher =ImageIO.read( new File("src/izone/pic1/Phone.png"));
				
					jToggleButton1 = new JToggleButton();		
					jToolBar1.add(jToggleButton1);
					jToggleButton1.setText("e-Voucher");
					jToggleButton1.setBounds(175, 49, 99, 27);
					
					if(imgVoucher!=null)
						jToggleButton1.setIcon(new ImageIcon(imgVoucher));					
					
					jToggleButton1.setPreferredSize(new java.awt.Dimension(99, 47));
					 
					jToggleButton1.addActionListener(new ActionListener(){
						public void actionPerformed(ActionEvent ev){
							Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
							
							//show e-Voucher Frame
							int l =(screen.width - jInternalFrame1.getWidth())/85;
							int t = (screen.height - jInternalFrame1.getHeight())/2;	
							
							
							jInternalFrame1.setLocation(new java.awt.Point(l, t));
							
							if(jInternalFrame1.isVisible()==false){
								jInternalFrame1.setVisible(true);
							}else{
								jInternalFrame1.setVisible(false);								
							}
						    //   JOptionPane.showMessageDialog(null,
		                    //            "Action Event"
		                    //            );

							}
						});
						
		
					
				
				}
				{
					BufferedImage imgSaldo = ImageIO.read(new File("src/izone/pic1/Cash.png"));
					jToggleButton2 = new JToggleButton();
					jToolBar1.add(jToggleButton2);
					jToggleButton2.setText("Cek Saldo");
					
					if(imgSaldo!=null)
						jToggleButton2.setIcon(new ImageIcon(imgSaldo));
					
					jToggleButton2.setPreferredSize(new java.awt.Dimension(99, 27));
					jToggleButton2.setBounds(175, 49, 99, 27);
					jToggleButton2.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent ev) {
							
							String responseCode="";
							String url="";
							String version="";
							String terminalID="";
							String key ="";
							String mac="";
							String balance="";
							Date date=new Date();
							String trxDate="";
							
							try{
								parameter data = new parameter();
								parameterDAO dao = new parameterDAO();
								url="http://202.169.46.85:7002/connector/iposgateway";
								data = dao.selectByparameterID("1");
								
								version =data.getVersion();
								terminalID= data.getTerminalID();
								key=data.getCipherKey();
								mac=getMAC.getMacAddr();
								
								
								XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
								config.setServerURL(new URL(url));
								XmlRpcClient client = new XmlRpcClient();
								client.setConfig(config);		
								
								Encryption enc = new Encryption();
								
								Hashtable struct = new Hashtable();
								struct.put("TransactionDateTime",date);
								struct.put("ProcessingCode","700000");
								struct.put("Version",version);
								struct.put("PIN",enc.performEncrypt("191411",key)); //enc
								struct.put("FirstName",enc.performEncrypt("BalanceInquiry",key)); //enc
													
								struct.put("TerminalID", terminalID);
								
								struct.put("MACAddress",mac);
								
								Vector params = new Vector();
								params.add(struct);
								//	params.add(new Integer(1));
								//	params.add(new Integer(1861));
								
	
								System.out.println(struct.toString());
								
								
								
								HashMap result = (HashMap) client.execute("iZoneGateway.balanceInquiry", params);
								
								System.out.println("response" +result.toString());
								
								responseCode = result.get("ResponseCode").toString();
								balance= result.get("TerminalBalance").toString();
								trxDate=result.get("TransactionDateTime").toString();
								
								if(responseCode.equals("00")||responseCode.equals("00")){
									
									System.out.println("Sukses");
									JOptionPane.showMessageDialog(null,
											"<html><h2><font color=#0000FF>Tanggal [ "+trxDate+" ]"+"<br>"+
											"Saldo Terminal [ Rp. "+balance+" ] </font></h2></html>");
																
								}								

							}
							catch(Exception e){
								e.printStackTrace();
							}
						}
					});
				}
				{
					BufferedImage imgKeluar = ImageIO.read(new File("src/izone/pic1/Stop.png"));
					jToggleButton3 = new JToggleButton();
					jToolBar1.add(jToggleButton3);
					jToggleButton3.setText("Keluar");
					
					if(imgKeluar!=null)
						jToggleButton3.setIcon(new ImageIcon(imgKeluar));
					
					jToggleButton3.setPreferredSize(new java.awt.Dimension(99,47));
					jToggleButton3.setBounds(175, 49, 99, 27);
					jToggleButton3.addActionListener(new ActionListener() {
						public void actionPerformed(ActionEvent ev) {
							System.exit(0);							
						}
					});
				}
				jToolBar1.putClientProperty("JToolBar.isRollover",Boolean.TRUE);
			}
			{
				jScrollPane1 = new JScrollPane();
				getContentPane().add(jScrollPane1);
				jScrollPane1.setBounds(43, 91, 1170, 228);
				{  
					//	TableModel jTable1Model = 
						//		new DefaultTableModel(
								//				new String[][] { { "One", "Two" }, { "Three", "Four" } },
								//				new String[] { "Column 1", "Column 2" });
					Object[] row ={"Log ID","Trx Date","Trx Type","ProductID",
							"Amount","Payee","SerialNo","ReferenceNo","trxStatus","PreviousBalance","CureentBalance"};
					tabMode = new DefaultTableModel(null,row);
					jTable1 = new JTable();
					jScrollPane1.setViewportView(jTable1);
					jTable1.setModel(tabMode);
					jTable1.setBounds(72, 144, 829, 163);
					viewData();
					jTable1.addMouseListener(new java.awt.event.MouseAdapter(){
						public void mouseClicked(MouseEvent e){
							try{
								System.out.println("test click");
								PrintExample print = new PrintExample();
								
								int row = jTable1.getSelectedRow();
								String TID="58001001";
								String date = tabMode.getValueAt(row, 1).toString();
								String amount = tabMode.getValueAt(row, 4).toString();
								String payee = tabMode.getValueAt(row, 5).toString();
								String serialNo = tabMode.getValueAt(row, 6).toString();
								String refNo = tabMode.getValueAt(row, 7).toString();
								String trxStatus = tabMode.getValueAt(row, 8).toString();
								
								print.printReceipt(TID,sdf.parse(date),payee,amount,refNo,serialNo,trxStatus.trim()) ;
							}catch(Exception ex){
								ex.printStackTrace();
							}
						}
					});
				}
			}

		}catch(Exception e)
		{
			e.printStackTrace();
		}
		
		return 0;
	}
	 
	private static void clearTable(){
		int row = tabMode.getRowCount();
		for(int i=0;i<row;i++){
			tabMode.removeRow(0);
		}
	}
	
	private static void viewData(){
		try{	  
			clearTable();
			transactionDAO trxdao = new transactionDAO();
			//Iterator it=trxdao.getTrxData(new Date()).getCollection().iterator();
			ClientCollection coll = trxdao.getTrxData(new Date());
			System.out.println("size:"+coll.size());
			Iterator it = coll.getCollections().iterator();
			
			sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			
			while(it.hasNext()){
				transaction trx = (transaction) it.next();
				String logID=trx.getLogID();
				String date=sdf.format(trx.getTrxDate());
				String trxType=trx.getTrxType();
				String productID=trx.getProductID();
				String amount=trx.getAmount();
				String payee=trx.getPayee();
				String serialNo=trx.getSerialNo();
				String refNo=trx.getReferenceNo();
				String trxStatus=trx.getTrxStatus();
				String previousBalance=trx.getPreviousBalance();
				String currentBalance=trx.getCurrentBalance();
				String[] data ={logID,date,trxType,productID,amount,payee,serialNo,
						refNo,trxStatus,previousBalance,currentBalance};
				
				tabMode.addRow(data);
			}
		}catch(Exception e){
			e.printStackTrace();
		}
		
	}
	//private void initGUI() {
		
	//	try {
	//		this.setPreferredSize(new java.awt.Dimension(400, 375));
	//		this.setLayout(null);
}
