package izone.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class transactionDAO {

	private DataConnection dbConn;
	private ResultSet rset;
	
	private SimpleDateFormat sdf;
	private SimpleDateFormat sdfDT;

	private ClientCollection clientcoll;
	
	public transactionDAO(){
		try{
			
			sdf= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			sdfDT = new SimpleDateFormat("yyyy-MM-dd");
			
			dbConn = new DataConnection();
			
			
		}catch(Exception e){
			e.printStackTrace();
		}
	}
	
	public void insertTrxData(transaction trx){
		
		try{
			dbConn.connect();
			
			PreparedStatement stmt = dbConn.preparedStatement("INSERT INTO tblTransactionLog VALUES (?,?,?,?,?,?,?,?,?,?,?);");
			stmt.setString(1, trx.getLogID());
			stmt.setString(2, sdf.format(trx.getTrxDate()));
			stmt.setString(3, trx.getTrxType());
			stmt.setString(4, trx.getProductID());
			stmt.setString(5, trx.getAmount());
			stmt.setString(6, trx.getPayee());
			stmt.setString(7, trx.getSerialNo());
			stmt.setString(8, trx.getReferenceNo());
			stmt.setString(9, trx.getTrxStatus());
			stmt.setString(10,trx.getPreviousBalance());
			stmt.setString(11,trx.getCurrentBalance());
			stmt.addBatch();
			stmt.executeBatch();
			
		}catch(SQLException sqle){
			System.out.println(sqle.getErrorCode()+"#"+sqle.getMessage());
		}finally{
			dbConn.disconnect();
		}
	}
	
	public void updateTrxData(transaction trx){
		String query=null;
		
		query="UPDATE tblTransactionLog SET "+
			"serialNo='"+trx.getSerialNo()+"',"+
			"referenceNo='"+trx.getReferenceNo()+"',"+
			"trxStatus='"+trx.getTrxStatus()+"',"+
			"previousBalance='"+trx.getPreviousBalance()+"',"+
			"currentBalance='"+ trx.getCurrentBalance()+"' "+
			"WHERE trxDate='"+sdf.format(trx.getTrxDate())+ "' AND "+
			"trxType='"+trx.getTrxType()+"' AND "+
			"payee='"+trx.getPayee() + "' AND " +
			"amount='"+trx.getAmount()+"';";
		
		try{
			dbConn.connect();			
			Statement stmt = dbConn.statement(query);
			stmt.executeUpdate(query.toString());
			
		}catch(SQLException sqle){
			System.out.println(sqle.getErrorCode()+"#"+sqle.getMessage());
		}finally{
			dbConn.disconnect();
			
		}
	
	}
	
	public ClientCollection getTrxData(Date dt){
		transaction data=null;
		String query=null;
		DateFormat df;
		
		clientcoll = new ClientCollection();
		
		query="SELECT * FROM tblTransactionLog where trxDate like'"+sdfDT.format(dt)+"%';";
		
		try{
			dbConn.connect();
			rset = dbConn.getResultSet(query);
			while(rset.next()){				
				String logID=rset.getString("logID");
				Date trxDate=sdf.parse(rset.getString("trxDate"));
				String trxType=rset.getString("trxType");
				String productID=rset.getString("productID");
				String amount=rset.getString("amount");
				String payee=rset.getString("payee");
				String serialNo=rset.getString("serialNo");
				String referenceNo=rset.getString("referenceNo");
				String trxStatus=rset.getString("trxStatus");
				String previousBalance=rset.getString("previousBalance");
				String currentBalance=rset.getString("currentBalance");
				
/**				System.out.println(logID);
				System.out.println(trxDate);
				System.out.println(trxType);
				System.out.println(productID);
				System.out.println(amount);
				System.out.println(payee);
				System.out.println(serialNo);
				System.out.println(referenceNo);
				System.out.println(trxStatus);
				System.out.println(previousBalance);
				System.out.println(currentBalance);
**/				
				
				data = new transaction(logID,trxDate,trxType,productID,amount,payee,
						serialNo,referenceNo,trxStatus,previousBalance,currentBalance);

				clientcoll.add(data);
				//System.out.println("coll size:"+clientcoll.size());
			}
			
			
		}catch(SQLException sqle){
			System.out.println("error: "+sqle.getErrorCode()+"#"+sqle.getMessage());
			
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			dbConn.disconnect();
		}
		
		
		return clientcoll;
	}
	
}
