package izone.client;

import javax.imageio.ImageIO;
import javax.swing.*;

import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;


import java.awt.*;
import java.awt.event.*;
import java.awt.image.BufferedImage;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.Date;

import izone.client.util.ExitListener;
import izone.client.util.OnlyDigit;
import izone.client.util.getMAC;
import izone.client.util.Encryption;
import izone.dao.parameter;
import izone.dao.parameterDAO;

import javax.jnlp.*;

/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class loginClient extends javax.swing.JFrame {
	private JTextArea jTextArea1;

	private JButton jButton1;
	private JLabel jLabel3;
	private JPasswordField txtPIN;
	private JLabel jLabel2;
	private JTextField txtUserID;
	private JLabel jLabel1;
	private JButton jButton2;


	public static void main(String[] args){		
		//Set Look & Feel
		try {
			javax.swing.UIManager.setLookAndFeel("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
			
			
			
			
		} catch(Exception e) {
			e.printStackTrace();
		}
		loginClient logClient = new loginClient();
		logClient.setPreferredSize(new java.awt.Dimension(83, 31));
	}
	
	public loginClient()
	{
		super();
		initGUI(1);
	}
	
	private int initGUI(int status){
		try{	

			addWindowListener(new ExitListener());
			Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
			
	
			setTitle("Login iZone Client");
			//frame.getContentPane().add(new loginClient(), BorderLayout.NORTH);
			getContentPane().setLayout(null);
			setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		

			int lebar =(screen.width - getWidth())/3;
			int tinggi = (screen.height -getHeight())/3;		

			setLocation(new java.awt.Point(lebar, tinggi));
			pack();
			
			BufferedImage image=ImageIO.read(new File("src/izone/pic/CircleLogo.jpg"));
			setIconImage(image);
			
			setSize(332, 218);
			setVisible(true);	
			{
				jButton1 = new JButton();
				getContentPane().add(jButton1);
				jButton1.setText("BATAL");
				jButton1.setBounds(206, 132, 70, 29);
				jButton1.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent event) {
						System.exit(0);
					}
				});
			}
			{
				jButton2 = new JButton();
				getContentPane().add(jButton2);
				jButton2.setText("LOGIN");
				jButton2.setBounds(125, 133, 70, 28);
				jButton2.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent event) {
						//	System.out.println("Inquiry");
						//	String url = "http://202.169.46.91:8220";
						String url = "http://202.169.46.85:7002/connector/iposgateway";
						try
						{
							String mac= getMAC.getMacAddr();
							
							if(mac==null)
								mac="00-00-00-00-00-00";
							
							parameter data = new parameter();
							parameterDAO dao = new parameterDAO();
							
							data = dao.selectByparameterID("1");
							
							if (data==null){										
								System.out.println("Gagal");
								JOptionPane.showMessageDialog(null,
										"Login Gagal\n Coba Lagi\nPesan Error :\n" + "<html><font color=#0000FF>" +
										"Gagal" + "</font></html>");
								System.exit(1);
							}
							
							String terminalID = data.getTerminalID();
							String version = data.getVersion();
							String key = data.getCipherKey();
							char[] pin = txtPIN.getPassword();
							
							System.out.println(new String(pin));
							
							XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
							config.setServerURL(new URL(url));
							XmlRpcClient client = new XmlRpcClient();
							client.setConfig(config);		
							
							Encryption enc = new Encryption();
							
							Hashtable struct = new Hashtable();
							struct.put("TransactionDateTime",new Date());
							struct.put("Version",version);
							struct.put("TerminalID", terminalID);
							struct.put("FirstName",enc.performEncrypt(txtUserID.getText().trim(),key));//enc
							struct.put("PIN",enc.performEncrypt(new String(pin),key)); //enc
							struct.put("MACAddress",mac);
							
							Vector params = new Vector();
							params.add(struct);
							//	params.add(new Integer(1));
							//	params.add(new Integer(1861));
							
							System.out.println(struct.toString());
							
							HashMap result = (HashMap) client.execute("iZoneGateway.loginClient", params);
							
							System.out.println("response" +result.toString());
							
							String responseCode = result.get("ResponseCode").toString();
							
							
							if(responseCode.equals("00")||responseCode.equals("00")){
								
								System.out.println("Sukses");
								JOptionPane.showMessageDialog(null,
										"<html><font color=#0000FF>Login Berhasil </font></html>");
								
								setVisible(false);
								
								mainClient mClient = new mainClient();
								
								
								
							}else
							{
								System.out.println("Gagal");
								JOptionPane.showMessageDialog(null,
										"Login Gagal\n Coba Lagi\nPesan Error :\n" + "<html><font color=#0000FF>" +
										"Gagal" + "</font></html>");
							}
							//H00FF0000
							
						}
						catch(Exception e)
						{
							e.printStackTrace();
						}
						
					}
				});
			}
			{
				jLabel1 = new JLabel();
				getContentPane().add(jLabel1);
				jLabel1.setText("UserID");
				jLabel1.setBounds(56, 75, 89, 14);
			}
			{
				jLabel2 = new JLabel();
				getContentPane().add(jLabel2);
				jLabel2.setText("PIN");
				jLabel2.setBounds(56, 102, 94, 14);
			}
			{
				txtUserID = new JTextField();
				getContentPane().add(txtUserID);
				txtUserID.setBounds(125, 72, 149, 21);
				txtUserID.setFocusable(true);
				txtUserID.requestFocusInWindow();
			}
			{
				txtPIN = new JPasswordField();
				getContentPane().add(txtPIN);
				txtPIN.setText("");
				txtPIN.setBounds(126, 99, 149, 22);
				txtPIN.setDocument(new OnlyDigit().getOnlyDigit());
			}
			{
				BufferedImage img = ImageIO.read(new File("src/izone/pic/iZoneLogo.bmp"));//this.getClass().getResource("/home/willy/Projects/PCClient1/src/iZoneLogo.bmp"));
				jLabel3 = new JLabel(new ImageIcon(img));
				getContentPane().add(jLabel3);
				jLabel3.setBounds(105, 16, 115, 44);
				//jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/izone/pic/iZoneLogo.bmp")));
			}

		}catch(Exception e)
		{
			e.printStackTrace();
		}
		
		return 0;
	}
	//private void initGUI() {
		
	//	try {
	//		this.setPreferredSize(new java.awt.Dimension(400, 375));
	//		this.setLayout(null);
}
